
If you find our code useful, please consider citing our work using the bibtex:

## Enviroment
 - Python3
 - Pytorch 1.9
 - json

## Dataset
### CUB
* run `write_CUB_filelist.py` after you download and unzip the dataset CUB to the folder "CUB"

### mini-ImageNet

* Visit https://github.com/dragen1860/MAML-Pytorch to get the folder 'images' and put it to folder "miniImagenet"
* Modify files "novel.json"，"base.json", and "val.json": modify the address inside these files to your own

## Train
Run
```python ./train.py --dataset [DATASETNAME] --model [BACKBONENAME] --method [METHODNAME] --n_shot [SHOT] [--OPTIONARG] ```

For example, our method CML:
run `python ./train.py --dataset CUB --model Conv4 --method constrained_implicit --weighting_mode COML  --n_shot 5 --resume  --train_aug`  

Commands below follow this example, and please refer to io_utils.py for additional options.

## Test
Run
```python ./test.py --dataset CUB --model Conv4 --method constrained_implicit --weighting_mode COML --n_shot 5 --resume  --train_aug```


## Acknowledgement
Thanks for the code framework provided by Ye, Feiyang and Lin, Baijiong and Yue, Zhixiong and Guo, Pengxin and Xiao, Qiao and Zhang, Yu. Here is their paper.

```
@article{
  ye2021multi,
  title={Multi-objective meta learning},
  author={Ye, Feiyang and Lin, Baijiong and Yue, Zhixiong and Guo, Pengxin and Xiao, Qiao and Zhang, Yu},
  journal={Advances in Neural Information Processing Systems},
  volume={34},
  pages={21338--21351},
  year={2021}
}
```

